require 'rubygems'
require 'sinatra'
require 'sinatra/synchrony'
require 'pp'

TOKEN = open("/etc/levels/wild-jellyfish.token").read.strip
CREDS = open("/etc/levels/wild-jellyfish.creds").read.strip

helpers do
  def protected!
    unless authorized?
      response['WWW-Authenticate'] = %(Basic realm="Restricted Area")
      throw(:halt, [401, "Not authorized\n"])
    end
  end

  def authorized?
    @auth ||=  Rack::Auth::Basic::Request.new(request.env)
    return false unless @auth.provided? && @auth.basic? && @auth.credentials
    creds = @auth.credentials.join(":")
    i = 0
    while CREDS[i] == creds[i] and i < CREDS.size and i < creds.size
      puts "#{i}: #{CREDS[i]}==#{creds[i]}"
      i+=1
      sleep(1)
    end
    if i == CREDS.size
      return true
    end
    return false
  end
end

get '/' do
  protected!
  TOKEN
end


